#include <stdio.h>
#include <math.h>
#include <gl.h>
#include <device.h>

double dot();

/***
 *** bzlogo versions of 1,i,j,k
 ***/

int one[] = {	101,228, 101,234, 104,226, 104,234, 107,226, -1,-1, 139,226,
		199,252, 141,214, 141,26, 89,28, -1,-1, 78,14, 52,0, 52,8,
		-1,-1, 49,8, 49,0, 49,5, -2,-2, 205,255, 202,252, 199,252,
		141,26, -2,-2, 179,5, 179,2, 173,8, 176,0, -1,-1, 173,0, 165,8,
		52,0, 144,14, 141,26, -3,-3};

int eye[] = {	165,51, 162,45, 162,51, -1,-1, 160,53, 134,11, 157,56, -1,-1,
		154,51, -1,-1, 131,28, 111,0, 128,28, -1,-1, 126,31, -1,-1,
		123,34, -1,-1, 109,141, 94,2, 80,31, 80,14, -2,-2, 160,172,
		160,170, 154,170, 123,34, -1,-1, 109,141, 89,161, 100,150,
		-1,-1, 92,153, -1,-1, 89,153, 86,158, 86,155, -2,-2, 174,240,
		174,223, 157,255, 165,209, -1,-1, 148,206, 143,255, 140,206,
		128,238, 126,223, -3,-3};

int jay[] = {	88,29, 85,16, 77,37, 85,13, -1,-1, 82,10, -1,-1, 82,0, -1,-1,
		80,2, -1,-1, 63,10, 63,35, 61,21, -2,-2, 123,181, 123,184,
		123,176, -1,-1, 126,176, 126,184, 136,176, 183,187, 142,168,
		145,46, -1,-1, 128,16, 107,27, 107,2, 96,10, 82,0, 85,10,
		82,10, -2,-2, 183,192, 183,189, 126,184, 183,187, -2,-2,
		193,246, 193,233, 183,255, 185,222, -1,-1, 174,219, 169,255,
		169,219, 158,244, 158,233, -3,-3};

int kay[] = {	69,238, 73,244, 73,234, -1,-1, 76,234, 76,244, 90,234, 141,255,
		93,227, 103,95, -1,-1, 103,88, -1,-1, 96,71, 93,224, 79,10,
		35,10, 76,3, -1,-1, 73,3, -1,-1, 39,3, 35,6, -2,-2, 147,255,
		144,248, 141,255, 103,95, -2,-2, 127,17, 113,74, 144,3, -1,-1,
		107,91, 110,78, -1,-1, 107,81, 103,88, 96,71, -2,-2, 158,153,
		154,156, 161,149, 195,146, -1,-1, 147,108, 154,132, -1,-1,
		107,91, 147,102, 144,3, -1,-1, 161,0, 161,37, -1,-1, 168,30,
		-1,-1, 175,27, 178,10, 178,27, -1,-1, 192,44, -1,-1, 195,47,
		202,40, 202,47, 205,44, -2,-2, 219,163, 219,156, 212,163,
		212,156, 144,163, 195,146, -1,-1, 154,156, -1,-1, 147,156,
		-1,-1, 144,156, 141,159, -3,-3};

main(argc,argv)
int argc;
char *argv[];
{
	double u[3],v[3],w[3],b[3],pl[3],pr[3],fft[3],ffn[3],ffb[3],
	      evp[4],ewp[4],ee[4],tag[4],newtag[4],
	      ft[4],fn[4],fb[4],
	      newft[4],newfn[4],newfb[4],
	      bb[26][3],
	      s,t,rho,theta,
	      alpha0,alpha1,dalpha,salpha,
	      phi0,phi1,dphi,sphi,
	      theta0,theta1,dtheta,
	      s2,lambda;
	float fnewfn[3];
	int i,j,last_i,last_j,
	    adjust,
	    *p;
	long xsize,ysize,xorg,yorg;
	char qstr[1024];
	Matrix textmatrix,ribbonmatrix;

	last_i = last_j = 0;

	/* Window size changes by Apostolos Lerios. */

	fprintf(stderr,"\n");
	fprintf(stderr,"To change the window size:\n");
	fprintf(stderr,"\n");
	fprintf(stderr,"1. Quit the application.\n");
	fprintf(stderr,"2. Restart the application by typing its name and\n");
	fprintf(stderr,"   hitting Return. Do not use the mouse buttons\n");
	fprintf(stderr,"   to place the application window.\n");
	fprintf(stderr,"3. Press the space bar.\n");
	fprintf(stderr,"4. Adjust the window size.\n");
	fprintf(stderr,"5. Click the mouse button.\n");
	fprintf(stderr,"\n");
	minsize(300,300);

	foreground();
	winopen("Belt Trick");
	getsize(&xsize,&ysize);
	getorigin(&xorg,&yorg);

	doublebuffer();
	RGBmode();
	gconfig();

	zbuffer(TRUE);
	lsetdepth(getgdesc(GD_ZMIN),getgdesc(GD_ZMAX));

	subpixel(TRUE);
	nmode(NNORMALIZE);	/* automatically normalize bad n3f() normals */

	mmode(MPROJECTION);
	ortho2(-0.5,(float) xsize - 0.5,-0.5,(float) ysize - 0.5);
	getmatrix(textmatrix);
	perspective(600,1.0,.1,10.0);
	getmatrix(ribbonmatrix);

	{
		static float yellowsurf[] =
			{AMBIENT, .5, .5, 0,
			 DIFFUSE, .5, .5, 0,
			 SPECULAR, .5, .5, .5,
			 SHININESS, 30,
			 LMNULL};

		static float bluesurf[] =
			{AMBIENT, 0, 0, .5,
			 DIFFUSE, 0, 0, .5,
			 SPECULAR, .5, .5, .5,
			 SHININESS, 30,
			 LMNULL};

		static float redsurf[] =
			{AMBIENT, .5, 0, 0,
			 DIFFUSE, .5, 0, 0,
			 SPECULAR, .5, .5, .5,
			 SHININESS, 30,
			 LMNULL};

		static float whitesurf[] =
			{AMBIENT, .5, .5, .5,
			 DIFFUSE, .5, .5, .5,
			 SPECULAR, .5, .5, .5,
			 SHININESS, 30,
			 LMNULL};

		static float overhead[] =
			{LCOLOR, 1, 1, 1,
			 POSITION, 0, 5, 0, 1,
			 LMNULL};

		static float lmodel[] =
			{LOCALVIEWER, 1.0,
			 TWOSIDE, 1,
			 LMNULL};

		lmdef(DEFMATERIAL, 1, 0, yellowsurf);
		lmdef(DEFMATERIAL, 2, 0, bluesurf);
		lmdef(DEFMATERIAL, 3, 0, redsurf);
		lmdef(DEFMATERIAL, 4, 0, whitesurf);
		lmdef(DEFLIGHT, 1, 0, overhead);
		lmdef(DEFLMODEL, 1, 0, lmodel);
	}

	mmode(MVIEWING);
	lmbind(LMODEL,1);
	lmbind(LIGHT0,1);

	tag[0] = 1.0;
	tag[1] = 0.0;
	tag[2] = 0.0;
	tag[3] = 0.0;

	/***
	 *** while forever
	 ***/

	while (1) {

		/***
		 *** check keys
		 ***/

		adjust = FALSE;

		if (getbutton(IKEY)) {

			evp[0] = cos(0.02);
			evp[1] = sin(0.02);
			evp[2] = 0.0;
			evp[3] = 0.0;

			if (getbutton(LEFTSHIFTKEY) ||
			    getbutton(RIGHTSHIFTKEY))
				evp[1] *= -1.0;

			qmult(tag,evp,newtag);
			adjust = TRUE;

		} else if (getbutton(JKEY)) {

			evp[0] = cos(0.02);
			evp[1] = 0.0;
			evp[2] = sin(0.02);
			evp[3] = 0.0;

			if (getbutton(LEFTSHIFTKEY) ||
			    getbutton(RIGHTSHIFTKEY))
				evp[2] *= -1.0;

			qmult(tag,evp,newtag);
			adjust = TRUE;

		} else if (getbutton(KKEY)) {

			evp[0] = cos(0.02);
			evp[1] = 0.0;
			evp[2] = 0.0;
			evp[3] = sin(0.02);

			if (getbutton(LEFTSHIFTKEY) ||
			    getbutton(RIGHTSHIFTKEY))
				evp[3] *= -1.0;

			qmult(tag,evp,newtag);
			adjust = TRUE;

		} else if (getbutton(SPACEKEY)) {
			tag[0] = 1.0;
			tag[1] = 0.0;
			tag[2] = 0.0;
			tag[3] = 0.0;
		}

		if (adjust) {
			/***
			 *** make sure belt moves slowly
			 ***/

			polar(tag,&alpha0,&phi0,&theta0);

			polar(newtag,&alpha1,&phi1,&theta1);

			dalpha = alpha1 - alpha0;
			dphi = phi1 - phi0;
			dtheta = theta1 - theta0;
			if (dtheta > M_PI)
				dtheta -= 2.0*M_PI;
			else if (dtheta < -M_PI)
				dtheta += 2.0*M_PI;

			s2 = sin(phi0);
			s2 = dphi*dphi + s2*s2 * dtheta*dtheta;

			if (s2 > 0.01 && alpha0 > M_PI_2) {
				lambda = sqrt(0.01/s2);

				dalpha *= lambda;
				dphi *= lambda;
				dtheta *= lambda;

				alpha1 = alpha0 + dalpha;
				phi1 = phi0 + dphi;
				theta1 = theta0 + dtheta;

				tag[0] = cos(alpha1);
				tag[1] = sin(alpha1)*sin(phi1)*cos(theta1);
				tag[2] = sin(alpha1)*sin(phi1)*sin(theta1);
				tag[3] = sin(alpha1)*cos(phi1);

			} else {
				tag[0] = newtag[0];
				tag[1] = newtag[1];
				tag[2] = newtag[2];
				tag[3] = newtag[3];
			}
		}

		/***
		 *** clear screen, init z-buffer
		 ***/

		czclear(0,getgdesc(GD_ZMAX));

		/***
		 *** write text
		 ***/

		mmode(MPROJECTION);
		loadmatrix(textmatrix);

		sprintf(qstr,"%6.3f%+06.3fi%+06.3fj%+06.3fk\n",
					tag[0],tag[1],tag[2],tag[3]);
		cmov2i(5,2);
		charstr(qstr);

		/***
		 *** adjust eye position
		 ***/

		i = getvaluator(MOUSEX);
		j = getvaluator(MOUSEY);

		i -= xorg;
		j -= yorg;

		mmode(MPROJECTION);
		loadmatrix(ribbonmatrix);
		if (i >= 0 && i < xsize && j >= 0 && j < ysize) {
			lookat(1.0 - 2.0 * (float) i/(xsize - 1),
			       1.0 - 2.0 * (float) j/(ysize - 1),
						1.5,0.0,0.0,0.0,0);
			last_i = i;
			last_j = j;
		} else {
			lookat(1.0 - 2.0 * (float) last_i/(xsize - 1),
			       1.0 - 2.0 * (float) last_j/(ysize - 1),
						1.5,0.0,0.0,0.0,0);
		}

		/***
		 *** draw axis
		 ***/

		RGBcolor(255,255,255);

		cmov(1.0,0.0,0.0);
		charstr("i");

		bgnline();
		v[0] = 0.0;
		v[1] = 0.0;
		v[2] = 0.0;
		v3d(v);
		v[0] = 1.0;
		v3d(v);
		endline();

		cmov(0.0,1.0,0.0);
		charstr("j");

		bgnline();
		v[0] = 0.0;
		v[1] = 0.0;
		v[2] = 0.0;
		v3d(v);
		v[1] = 1.0;
		v3d(v);
		endline();

		cmov(0.0,0.0,1.0);
		charstr("k");

		bgnline();
		v[0] = 0.0;
		v[1] = 0.0;
		v[2] = 0.0;
		v3d(v);
		v[2] = 1.0;
		v3d(v);
		endline();

		/***
		 *** b = point on belt
		 ***/

		b[0] = 0.0;
		b[1] = 0.0;
		b[2] = 0.0;

		/***
		 *** (quaternion) frenet frame of belt
		 *** normalized for implementation
		 ***/

		ft[0] = 0.0;
		ft[1] = 0.0;
		ft[2] = 0.0;
		ft[3] = 1.0/256.0;	/* tangent for unit length belt */

		fn[0] = 0.0;
		fn[1] = 0.0;
		fn[2] = 1.0;		/* belt surface normal */
		fn[3] = 0.0;

		fb[0] = 0.0;
		fb[1] = 0.1;		/* radius of belt */
		fb[2] = 0.0;
		fb[3] = 0.0;

		/***
		 *** shade belt yellow on one side, blue on the other
		 ***/

		lmbind(MATERIAL,1);
		lmbind(BACKMATERIAL,2);
		bgnqstrip();

		for (i = 0; i <= 256; i++) {

			/***
			 *** compute next vertices
			 ***/

			theta = (double)i/256.0;

			rho = sqrt(dot(&tag[1],&tag[1]));
			if (rho == 0.0) {
				vscale(0.0,&tag[1],u);
			} else {
				vscale(1.0/rho,&tag[1],u);
			}
			vscale(fatan2(rho,tag[0]),u,v);

			vscale(theta,v,w);

			qexp(w,ewp);

			R(ewp,ft,newft);
			R(ewp,fn,newfn);
			R(ewp,fb,newfb);

			/***
			 *** plot left and right vertices
			 ***/

			vadd(b,&newfb[1],pr);
			vsub(b,&newfb[1],pl);

			fnewfn[0] = newfn[1];
			fnewfn[1] = newfn[2];
			fnewfn[2] = newfn[3];

			n3f(fnewfn);
			v3d(pr);
			n3f(fnewfn);
			v3d(pl);

			if (i >= 231)
				vscale(1.0,b,bb[i-231]);

			vadd(b,&newft[1],b);
		}

		endqstrip();

		/***
		 *** draw axes labels
		 ***/

		lmbind(MATERIAL,3);
		lmbind(BACKMATERIAL,3);

		/***
		 *** one
		 ***/

		bgntmesh();

		for (p = one; *p != -3; p += 2) {

			if (*p == -1) {
				swaptmesh();
				continue;
			}

			if (*p == -2) {
				endtmesh();
				bgntmesh();
				continue;
			}

			i = 25 - p[1]/10;

			theta = 0.9 + (double)i/250.0;

			rho = sqrt(dot(&tag[1],&tag[1]));
			if (rho == 0.0) {
				vscale(0.0,&tag[1],u);
			} else {
				vscale(1.0/rho,&tag[1],u);
			}
			vscale(fatan2(rho,tag[0]),u,v);

			vscale(theta,v,w);

			qexp(w,ewp);

			R(ewp,ft,newft);
			R(ewp,fn,newfn);
			R(ewp,fb,newfb);

			fnewfn[0] = -newfn[1];
			fnewfn[1] = -newfn[2];
			fnewfn[2] = -newfn[3];

			n3f(fnewfn);

			vscale((double) p[0]/256.0 - 1.0,&newfb[1],&newfb[1]);
			vadd(bb[i],&newfb[1],v);

			vscale(0.005,&newfn[1],&newfn[1]);
			vadd(v,&newfn[1],v);

			v3d(v);
		}

		endtmesh();

		/***
		 *** jay
		 ***/

		bgntmesh();

		for (p = jay; *p != -3; p += 2) {

			if (*p == -1) {
				swaptmesh();
				continue;
			}

			if (*p == -2) {
				endtmesh();
				bgntmesh();
				continue;
			}

			i = p[1]/10;

			theta = 0.9 + (double)i/250.0;

			rho = sqrt(dot(&tag[1],&tag[1]));
			if (rho == 0.0) {
				vscale(0.0,&tag[1],u);
			} else {
				vscale(1.0/rho,&tag[1],u);
			}
			vscale(fatan2(rho,tag[0]),u,v);

			vscale(theta,v,w);

			qexp(w,ewp);

			R(ewp,ft,newft);
			R(ewp,fn,newfn);
			R(ewp,fb,newfb);

			fnewfn[0] = -newfn[1];
			fnewfn[1] = -newfn[2];
			fnewfn[2] = -newfn[3];

			n3f(fnewfn);

			vscale(1.0 - (double) p[0]/256.0,&newfb[1],&newfb[1]);
			vadd(bb[i],&newfb[1],v);

			vscale(0.005,&newfn[1],&newfn[1]);
			vadd(v,&newfn[1],v);

			v3d(v);
		}

		endtmesh();

		/***
		 *** draw axes labels
		 ***/

		lmbind(MATERIAL,4);
		lmbind(BACKMATERIAL,4);

		/***
		 *** kay
		 ***/

		bgntmesh();

		for (p = kay; *p != -3; p += 2) {

			if (*p == -1) {
				swaptmesh();
				continue;
			}

			if (*p == -2) {
				endtmesh();
				bgntmesh();
				continue;
			}

			i = 25 - p[1]/10;

			theta = 0.9 + (double)i/250.0;

			rho = sqrt(dot(&tag[1],&tag[1]));
			if (rho == 0.0) {
				vscale(0.0,&tag[1],u);
			} else {
				vscale(1.0/rho,&tag[1],u);
			}
			vscale(fatan2(rho,tag[0]),u,v);

			vscale(theta,v,w);

			qexp(w,ewp);

			R(ewp,ft,newft);
			R(ewp,fn,newfn);
			R(ewp,fb,newfb);

			fnewfn[0] = newfn[1];
			fnewfn[1] = newfn[2];
			fnewfn[2] = newfn[3];

			n3f(fnewfn);

			vscale(1.0 - (double) p[0]/256.0,&newfb[1],&newfb[1]);
			vadd(bb[i],&newfb[1],v);

			vscale(-0.005,&newfn[1],&newfn[1]);
			vadd(v,&newfn[1],v);

			v3d(v);
		}

		endtmesh();

		/***
		 *** eye
		 ***/

		bgntmesh();

		for (p = eye; *p != -3; p += 2) {

			if (*p == -1) {
				swaptmesh();
				continue;
			}

			if (*p == -2) {
				endtmesh();
				bgntmesh();
				continue;
			}

			i = p[1]/10;

			theta = 0.9 + (double)i/250.0;

			rho = sqrt(dot(&tag[1],&tag[1]));
			if (rho == 0.0) {
				vscale(0.0,&tag[1],u);
			} else {
				vscale(1.0/rho,&tag[1],u);
			}
			vscale(fatan2(rho,tag[0]),u,v);

			vscale(theta,v,w);

			qexp(w,ewp);

			R(ewp,ft,newft);
			R(ewp,fn,newfn);
			R(ewp,fb,newfb);

			fnewfn[0] = newfn[1];
			fnewfn[1] = newfn[2];
			fnewfn[2] = newfn[3];

			n3f(fnewfn);

			vscale((double) p[0]/256.0 - 1.0,&newfb[1],&newfb[1]);
			vadd(bb[i],&newfb[1],v);

			vscale(-0.005,&newfn[1],&newfn[1]);
			vadd(v,&newfn[1],v);

			v3d(v);
		}

		endtmesh();

		swapbuffers();
	}
}

polar(q,alpha,phi,theta)
double *q,*alpha,*phi,*theta;
{
	double salpha,salphasphi;

	if (q[0] > 1.0)
		*alpha = 0.0;
	else if (q[0] < -1.0)
		*alpha = M_PI;
	else
		*alpha = acos(q[0]);

	salpha = sin(*alpha);

	if (salpha == 0.0) {
		*phi = 0.0;
		*theta = 0.0;
	} else {
		if (fabs(q[3]) > fabs(salpha)) {
			if (q[3]*salpha < 0.0)
				*phi = M_PI;
			else
				*phi = 0.0;
		} else {
			*phi = acos(q[3]/salpha);
		}

		salphasphi = salpha*sin(*phi);

		if (salphasphi == 0.0 || fabs(q[1]) > fabs(salphasphi)) {
			if (q[1]*salphasphi < 0.0)
				*theta = M_PI;
			else
				*theta = 0.0;
		} else {
			*theta = acos(q[1]/salphasphi);
			if (q[2] < 0.0)
				*theta = -*theta;
		}
	}

	if (*alpha < 0.0) *alpha += 2.0*M_PI;
	if (*phi < 0.0) *phi += 2.0*M_PI;
	if (*theta < 0.0) *theta += 2.0*M_PI;
}

double dot(a,b)
double *a,*b;
{
	double d;

	d = *a++ * *b++;
	d += *a++ * *b++;
	d += *a++ * *b++;

	return(d);
}

cross(a,b,c)
double *a,*b,*c;
{
	*c++ = a[1]*b[2] - a[2]*b[1];
	*c++ = a[2]*b[0] - a[0]*b[2];
	*c = a[0]*b[1] - a[1]*b[0];
}

vscale(a,b,c)
double a,*b,*c;
{
	*c++ = a * *b++;
	*c++ = a * *b++;
	*c = a * *b++;
}

vadd(a,b,c)
double *a,*b,*c;
{
	*c++ = *a++ + *b++;
	*c++ = *a++ + *b++;
	*c = *a + *b;
}

vsub(a,b,c)
double *a,*b,*c;
{
	*c++ = *a++ - *b++;
	*c++ = *a++ - *b++;
	*c = *a - *b;
}

qmult(a,b,c)
double *a,*b,*c;
{
	double dud[3];

	/***
	 *** (a*b)[0] = a[0]b[0] - a[123] . b[123]
	 *** (a*b)[123] = a[0]b[123] + b[0]a[123] + a[123] x b[123]
	 ***/

	*c = *a++ * *b++;	/* (a*b)[0] = a[0]b[0] */
	*c++ -= dot(a,b);	/* (a*b)[0] -= a[123].b[123] */
	cross(a--,b,c);		/* (a*b)[123] = a[123] x b[123] */
	vscale(*a++,b--,dud);	/* (a*b)[123] += a[0]b[123] */
	vadd(c,dud,c);
	vscale(*b,a,dud);	/* (a*b)[123] += b[0]a[123] */
	vadd(c,dud,c);
}

qexp(a,b)
double *a,*b;
{
	double alpha,u[3];

	/***
	 *** b[0] = cos(alpha)
	 *** b[123] = sin(alpha)*u[123]
	 ***/

	alpha = sqrt(dot(a,a));
	*b++ = cos(alpha);
	if (alpha == 0.0) {
		vscale(0.0,a,b);
	} else {
		vscale(1.0/alpha,a,u);
		vscale(sin(alpha),u,b);
	}
}

R(a,b,c)
double *a,*b,*c;
{
	double dud[4],astar[4];

	/***
	 *** c = a b a*
	 ***/

	qmult(a,b,dud);
	qconj(a,astar);
	qmult(dud,astar,c);
}

qconj(a,b)
double *a,*b;
{
	*b++ = *a++;
	vscale(-1.0,a,b);
}

qrenorm(a)
double *a;
{
	double l;

	l = a[0]*a[0] + a[1]*a[1] + a[2]*a[2] + a[3]*a[3];

	l = 1.0/sqrt(l);

	*a++ *= l;
	*a++ *= l;
	*a++ *= l;
	*a *= l;
}
