##
## 3/06/2001
## http://graphics.stanford.edu/software/wiregl
##
## Copyright 2001
## The Board of Trustees of The Leland Stanford Junior University.
## All rights reserved.
##
## Except for commercial resale, lease, license or other commercial
## transactions, permission is hereby given to use, copy, and/or
## modify this software, provided that the above copyright notice and
## this permission notice appear in all copies of this software.  No
## part of this software or any derivatives thereof may be used in
## graphics systems for resale or for use in a commercial product.
##
## This software is provided "as is" and without warranty of any kind,
## express, implied or otherwise, including without limitation, any
## warranty of merchantability or fitness for a particular purpose.
##

require 'glcurrent_types.pl';

print <<EOF;

/* Generated by glcurrent.pl */
#include "glcontext.h"

EOF

foreach $k (keys (%gltypes)) {
	print "#define CONVERT_$k(a) ((GLfloat) (a))\n";
}

%scale = (
	'ub' => 'GL_MAXUBYTE',
	'b'  => 'GL_MAXBYTE',
	'us' => 'GL_MAXUSHORT',
	's'  => 'GL_MAXSHORT',
	'ui' => 'GL_MAXUINT',
	'i'  => 'GL_MAXINT',
	'f'  => '',
	'd'  => ''
);

foreach $k (keys (%gltypes)) {
	if ($k ne 'f' && $k ne 'd' && $k ne 'l') {
		print "#define CONVERT_RESCALE_$k(a) (((GLfloat) (a)) / $scale{$k})\n\n";
	}
}


for ($loop = 0; $loop < 2; $loop++) {
	foreach $k (keys (%hash)) {
		$name = $k;
		$ucname = uc $k;
		$lcname = lc $k;
		$num_members = $#{$hash{$k}{default}} + 1;

		foreach $type (@ {$hash{$k}{types}}) {
			foreach $size (@ {$hash{$k}{sizes}}) {
				$uctype = uc $type;
				if ($hash{$k}{types}[0] eq 'l') {
					print "void GLSTATE_DECL __glstate_${name}";
				} elsif ($size == 1 && $#{$hash{$k}{sizes}} == 0) {
					print "void GLSTATE_DECL __glstate_${name}${type}";
				} else {
					print "void GLSTATE_DECL __glstate_${name}${size}${type}";
				}
				print "v" if ($loop == 1);
				print "(";
				if ($loop == 0) {
					for ($i=0; $i<$size; $i++) {
						print "$gltypes{$type}{type} v$i";
						print ", " if ($i < $size-1);
					}
				} else {
					print "const $gltypes{$type}{type} *v";
				}

				print ")\n";

				print <<EOF;
{
  GLcontext *g = GetCurrentContext();
  GLcurrentstate *c = &(g->current);
EOF
				$rescale = "";
				$rescale = "RESCALE_" if ($hash{$k}{rescale} == 1 && $type ne "f" && $type ne "d");

				$dot = ".";
				$dot = "" if ($#{$hash{$k}{members}} == -1);

				$convert = "CONVERT_$rescale$type";
				$convert = "" if ($hash{$k}{native} eq $type);

				for ($i = 0; $i < $size; $i++) {
					print "  c->$lcname$dot$hash{$k}{members}[$i] = $convert (";
					if ($loop == 0) {
						print "v$i";
					} else {
						print "v[$i]";
					}
					print ");\n";
				}

				for ($i; $i <= $#{$hash{$k}{members}}; $i++) {
					print "  c->$lcname$dot$hash{$k}{members}[$i] = $hash{$k}{default}[$i];\n";
				}

				print "}\n\n";
			}
		}

	}
}